"""
Система переводов для приложения
"""
from typing import Dict, Any

class Translator:
    """Класс для управления переводами"""
    
    def __init__(self):
        self.current_language = "ru"
        self.translations = {
            "ru": {
                "app_title": "Maxport AIagent - Искусственный Интеллект",
                "thinking": "Думаю...",
                "ready": "Готов",
                "error": "Ошибка",
                "success": "Успешно",
                "loading": "Загрузка...",
                "voice_enabled": "Голос включен",
                "voice_disabled": "Голос отключен",
                "settings": "Настройки",
                "language": "Язык",
                "theme": "Тема",
                "save": "Сохранить",
                "cancel": "Отмена",
                "ok": "ОК",
                "yes": "Да",
                "no": "Нет",
                "close": "Закрыть",
                "minimize": "Свернуть",
                "maximize": "Развернуть",
                "about": "О программе",
                "help": "Помощь",
                "exit": "Выход",
                "file": "Файл",
                "edit": "Правка",
                "view": "Вид",
                "tools": "Инструменты",
                "plugins": "Плагины",
                "creative_studio": "Творческая студия",
                "voice_control": "Голосовое управление",
                "web_search": "Веб-поиск",
                "code_generation": "Генерация кода",
                "system_optimization": "Оптимизация системы",
                "change_theme": "Изменить тему",
                "enter_message_placeholder": "Введите сообщение...",
                "send_button": "Отправить",
                "ai_settings_tab": "Настройки ИИ",
                "monitoring_tab": "Мониторинг",
                "ai_model_settings": "Настройки модели ИИ",
                "hardware_specs": "Характеристики оборудования",
                "ram": "ОЗУ",
                "cpu_threads": "Потоки CPU",
                "recommended_model_size": "Рекомендуемый размер модели",
                "gpu_acceleration": "Ускорение GPU",
                "gpu_offload_percent": "Процент выгрузки на GPU",
                "local_model": "Локальная модель",
                "apply": "Применить",
                "temperature": "Температура",
                "context_length": "Длина контекста",
                "available_models_for_download": "Доступные модели для загрузки",
                "find_models": "Найти модели",
                "download_selected_model": "Загрузить выбранную модель",
                "cloud_ai_models": "Облачные модели ИИ",
                "enter_api_key_placeholder": "Введите API ключ...",
                "add": "Добавить",
                "voice_settings": "Настройки голоса",
                "speak_responses": "Озвучивать ответы",
                "voice_selection": "Выбор голоса",
                "privacy_settings": "Настройки приватности",
                "allow_data_transfer": "Разрешить передачу данных",
                "cleanup_old_data": "Очистка старых данных",
                "cpu_usage": "Использование CPU",
                "ram_usage": "Использование ОЗУ",
                "gpu_usage": "Использование GPU",
                "processes": "Процессы",
                "name_header": "Имя",
                "cpu_header": "CPU %",
                "memory_header": "Память",
                "select_model_to_load": "Выберите модель для загрузки",
                "loading_model": "Загрузка модели: {model_name}",
                "process_info_question": "Объясни простыми словами, что делает процесс с именем '{process_name}'.\nОн запущен пользователем: {username}.\nПуть к исполняемому файлу: {exe_path}.\nКомандная строка запуска: {cmdline}\n\nЯвляется ли этот процесс системным или пользовательским? Это легитимный процесс или он может быть подозрительным?",
                "stop_process": "Остановить процесс",
                "ask_about_process": "Спросить о процессе",
                "models_not_found": "Модели не найдены",
                "searching_models": "Поиск моделей...",
                "search_error": "Ошибка поиска",
                "initial_greeting": "Привет! Я Maxport. Чем могу помочь?",
                "chat_tab_title": "Чат",
                "rename_chat_title": "Переименовать чат",
                "new_chat_name_label": "Новое имя чата:",
                "gpu_not_found": "GPU не найден",
                "no_model_selected": "Модель не выбрана",
                "analyze_screen_title": "Анализ экрана",
                "analyze_screen_prompt": "Что искать на скриншоте?",
                "model_loaded_successfully": "Модель успешно загружена!",
                "model_load_error": "Ошибка загрузки модели",
                "search_error": "Ошибка поиска",
                "remove": "Удалить",
                "test": "Тест",
                "testing": "Тестирую...",
                "api_test_success": "API ключ работает корректно!",
                "api_test_error": "API ключ не работает. Проверьте ключ и попробуйте снова.",
                "select_api_for_test": "Выберите API ключ для тестирования"
            },
            "en": {
                "app_title": "Maxport AIagent - Artificial Intelligence",
                "thinking": "Thinking...",
                "ready": "Ready",
                "error": "Error",
                "success": "Success",
                "loading": "Loading...",
                "voice_enabled": "Voice enabled",
                "voice_disabled": "Voice disabled",
                "settings": "Settings",
                "language": "Language",
                "theme": "Theme",
                "save": "Save",
                "cancel": "Cancel",
                "ok": "OK",
                "yes": "Yes",
                "no": "No",
                "close": "Close",
                "minimize": "Minimize",
                "maximize": "Maximize",
                "about": "About",
                "help": "Help",
                "exit": "Exit",
                "file": "File",
                "edit": "Edit",
                "view": "View",
                "tools": "Tools",
                "plugins": "Plugins",
                "creative_studio": "Creative Studio",
                "voice_control": "Voice Control",
                "web_search": "Web Search",
                "code_generation": "Code Generation",
                "system_optimization": "System Optimization",
                "change_theme": "Change Theme",
                "enter_message_placeholder": "Enter message...",
                "send_button": "Send",
                "ai_settings_tab": "AI Settings",
                "monitoring_tab": "Monitoring",
                "ai_model_settings": "AI Model Settings",
                "hardware_specs": "Hardware Specifications",
                "ram": "RAM",
                "cpu_threads": "CPU Threads",
                "recommended_model_size": "Recommended Model Size",
                "gpu_acceleration": "GPU Acceleration",
                "gpu_offload_percent": "GPU Offload Percent",
                "local_model": "Local Model",
                "apply": "Apply",
                "temperature": "Temperature",
                "context_length": "Context Length",
                "available_models_for_download": "Available Models for Download",
                "find_models": "Find Models",
                "download_selected_model": "Download Selected Model",
                "cloud_ai_models": "Cloud AI Models",
                "enter_api_key_placeholder": "Enter API key...",
                "add": "Add",
                "voice_settings": "Voice Settings",
                "speak_responses": "Speak Responses",
                "voice_selection": "Voice Selection",
                "privacy_settings": "Privacy Settings",
                "allow_data_transfer": "Allow Data Transfer",
                "cleanup_old_data": "Cleanup Old Data",
                "cpu_usage": "CPU Usage",
                "ram_usage": "RAM Usage",
                "gpu_usage": "GPU Usage",
                "processes": "Processes",
                "name_header": "Name",
                "cpu_header": "CPU %",
                "memory_header": "Memory",
                "select_model_to_load": "Select model to load",
                "loading_model": "Loading model: {model_name}",
                "process_info_question": "Explain in simple terms what the process named '{process_name}' does.\nIt is run by user: {username}.\nPath to executable file: {exe_path}.\nCommand line launch: {cmdline}\n\nIs this a system or user process? Is this a legitimate process or could it be suspicious?",
                "stop_process": "Stop process",
                "ask_about_process": "Ask about process",
                "models_not_found": "Models not found",
                "searching_models": "Searching models...",
                "search_error": "Search error",
                "initial_greeting": "Hello! I'm Maxport. How can I help?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Rename chat",
                "new_chat_name_label": "New chat name:",
                "gpu_not_found": "GPU not found",
                "no_model_selected": "No model selected",
                "analyze_screen_title": "Screen Analysis",
                "analyze_screen_prompt": "What to look for in the screenshot?",
                "model_loaded_successfully": "Model loaded successfully!",
                "remove": "Remove",
                "test": "Test",
                "testing": "Testing...",
                "api_test_success": "API key works correctly!",
                "api_test_error": "API key doesn't work. Check the key and try again.",
                "select_api_for_test": "Select API key for testing",
                "model_load_error": "Model loading error",
                "search_error": "Search error"
            },
            "de": {
                "app_title": "Maxport AIagent - Künstliche Intelligenz",
                "thinking": "Denke...",
                "ready": "Bereit",
                "error": "Fehler",
                "success": "Erfolg",
                "loading": "Lade...",
                "voice_enabled": "Stimme aktiviert",
                "voice_disabled": "Stimme deaktiviert",
                "settings": "Einstellungen",
                "language": "Sprache",
                "theme": "Design",
                "save": "Speichern",
                "cancel": "Abbrechen",
                "ok": "OK",
                "yes": "Ja",
                "no": "Nein",
                "close": "Schließen",
                "minimize": "Minimieren",
                "maximize": "Maximieren",
                "about": "Über",
                "help": "Hilfe",
                "exit": "Beenden",
                "file": "Datei",
                "edit": "Bearbeiten",
                "view": "Ansicht",
                "tools": "Werkzeuge",
                "plugins": "Plugins",
                "creative_studio": "Kreatives Studio",
                "voice_control": "Sprachsteuerung",
                "web_search": "Websuche",
                "code_generation": "Code-Generierung",
                "system_optimization": "Systemoptimierung",
                "change_theme": "Design ändern",
                "enter_message_placeholder": "Nachricht eingeben...",
                "send_button": "Senden",
                "ai_settings_tab": "KI-Einstellungen",
                "monitoring_tab": "Überwachung",
                "ai_model_settings": "KI-Modell-Einstellungen",
                "hardware_specs": "Hardware-Spezifikationen",
                "ram": "RAM",
                "cpu_threads": "CPU-Threads",
                "recommended_model_size": "Empfohlene Modellgröße",
                "gpu_acceleration": "GPU-Beschleunigung",
                "gpu_offload_percent": "GPU-Auslagerungsprozentsatz",
                "local_model": "Lokales Modell",
                "apply": "Anwenden",
                "temperature": "Temperatur",
                "context_length": "Kontextlänge",
                "available_models_for_download": "Verfügbare Modelle zum Download",
                "find_models": "Modelle finden",
                "download_selected_model": "Ausgewähltes Modell herunterladen",
                "cloud_ai_models": "Cloud-KI-Modelle",
                "enter_api_key_placeholder": "API-Schlüssel eingeben...",
                "add": "Hinzufügen",
                "voice_settings": "Stimmeinstellungen",
                "speak_responses": "Antworten vorlesen",
                "voice_selection": "Stimmenauswahl",
                "privacy_settings": "Datenschutzeinstellungen",
                "allow_data_transfer": "Datenübertragung erlauben",
                "cleanup_old_data": "Alte Daten bereinigen",
                "cpu_usage": "CPU-Auslastung",
                "ram_usage": "RAM-Auslastung",
                "gpu_usage": "GPU-Auslastung",
                "processes": "Prozesse",
                "name_header": "Name",
                "cpu_header": "CPU %",
                "memory_header": "Speicher",
                "select_model_to_load": "Modell zum Laden auswählen",
                "loading_model": "Lade Modell: {model_name}",
                "process_info_question": "Erkläre in einfachen Worten, was der Prozess '{process_name}' tut.\nEr wird vom Benutzer ausgeführt: {username}.\nPfad zur ausführbaren Datei: {exe_path}.\nBefehlszeile: {cmdline}\n\nIst dies ein System- oder Benutzerprozess? Ist dies ein legitimer Prozess oder könnte er verdächtig sein?",
                "stop_process": "Prozess stoppen",
                "ask_about_process": "Nach Prozess fragen",
                "models_not_found": "Modelle nicht gefunden",
                "searching_models": "Suche Modelle...",
                "search_error": "Suchfehler",
                "initial_greeting": "Hallo! Ich bin Maxport. Wie kann ich helfen?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Chat umbenennen",
                "new_chat_name_label": "Neuer Chat-Name:",
                "gpu_not_found": "GPU nicht gefunden",
                "no_model_selected": "Kein Modell ausgewählt",
                "analyze_screen_title": "Bildschirmanalyse",
                "analyze_screen_prompt": "Wonach soll auf dem Screenshot gesucht werden?",
                "model_loaded_successfully": "Modell erfolgreich geladen!",
                "remove": "Entfernen",
                "test": "Test",
                "testing": "Teste...",
                "api_test_success": "API-Schlüssel funktioniert korrekt!",
                "api_test_error": "API-Schlüssel funktioniert nicht. Überprüfen Sie den Schlüssel und versuchen Sie es erneut.",
                "select_api_for_test": "API-Schlüssel zum Testen auswählen",
                "model_load_error": "Fehler beim Laden des Modells",
                "search_error": "Suchfehler",
                "edit_message": "Nachricht bearbeiten",
                "delete_message": "Nachricht löschen",
                "edit_dialog_title": "Nachricht bearbeiten",
                "message_label": "Nachricht:",
                "upload_file_tooltip": "Datei hochladen",
                "attach_image_tooltip": "Bild anhängen"
            },
            "es": {
                "app_title": "Maxport AIagent - Inteligencia Artificial",
                "thinking": "Pensando...",
                "ready": "Listo",
                "error": "Error",
                "success": "Éxito",
                "loading": "Cargando...",
                "voice_enabled": "Voz activada",
                "voice_disabled": "Voz desactivada",
                "settings": "Configuración",
                "language": "Idioma",
                "theme": "Tema",
                "save": "Guardar",
                "cancel": "Cancelar",
                "ok": "OK",
                "yes": "Sí",
                "no": "No",
                "close": "Cerrar",
                "minimize": "Minimizar",
                "maximize": "Maximizar",
                "about": "Acerca de",
                "help": "Ayuda",
                "exit": "Salir",
                "file": "Archivo",
                "edit": "Editar",
                "view": "Ver",
                "tools": "Herramientas",
                "plugins": "Complementos",
                "creative_studio": "Estudio Creativo",
                "voice_control": "Control de Voz",
                "web_search": "Búsqueda Web",
                "code_generation": "Generación de Código",
                "system_optimization": "Optimización del Sistema",
                "change_theme": "Cambiar Tema",
                "enter_message_placeholder": "Ingrese mensaje...",
                "send_button": "Enviar",
                "ai_settings_tab": "Configuración de IA",
                "monitoring_tab": "Monitoreo",
                "ai_model_settings": "Configuración del Modelo de IA",
                "hardware_specs": "Especificaciones de Hardware",
                "ram": "RAM",
                "cpu_threads": "Hilos de CPU",
                "recommended_model_size": "Tamaño de Modelo Recomendado",
                "gpu_acceleration": "Aceleración GPU",
                "gpu_offload_percent": "Porcentaje de Descarga GPU",
                "local_model": "Modelo Local",
                "apply": "Aplicar",
                "temperature": "Temperatura",
                "context_length": "Longitud de Contexto",
                "available_models_for_download": "Modelos Disponibles para Descargar",
                "find_models": "Buscar Modelos",
                "download_selected_model": "Descargar Modelo Seleccionado",
                "cloud_ai_models": "Modelos de IA en la Nube",
                "enter_api_key_placeholder": "Ingrese clave API...",
                "add": "Agregar",
                "voice_settings": "Configuración de Voz",
                "speak_responses": "Hablar Respuestas",
                "voice_selection": "Selección de Voz",
                "privacy_settings": "Configuración de Privacidad",
                "allow_data_transfer": "Permitir Transferencia de Datos",
                "cleanup_old_data": "Limpiar Datos Antiguos",
                "cpu_usage": "Uso de CPU",
                "ram_usage": "Uso de RAM",
                "gpu_usage": "Uso de GPU",
                "processes": "Procesos",
                "name_header": "Nombre",
                "cpu_header": "CPU %",
                "memory_header": "Memoria",
                "select_model_to_load": "Seleccionar modelo para cargar",
                "loading_model": "Cargando modelo: {model_name}",
                "process_info_question": "Explica en términos simples qué hace el proceso llamado '{process_name}'.\nEs ejecutado por el usuario: {username}.\nRuta al archivo ejecutable: {exe_path}.\nLínea de comando: {cmdline}\n\n¿Es un proceso del sistema o del usuario? ¿Es un proceso legítimo o podría ser sospechoso?",
                "stop_process": "Detener proceso",
                "ask_about_process": "Preguntar sobre proceso",
                "models_not_found": "Modelos no encontrados",
                "searching_models": "Buscando modelos...",
                "search_error": "Error de búsqueda",
                "initial_greeting": "¡Hola! Soy Maxport. ¿Cómo puedo ayudar?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Renombrar chat",
                "new_chat_name_label": "Nuevo nombre de chat:",
                "gpu_not_found": "GPU no encontrada",
                "no_model_selected": "Ningún modelo seleccionado",
                "analyze_screen_title": "Análisis de Pantalla",
                "analyze_screen_prompt": "¿Qué buscar en la captura de pantalla?",
                "model_loaded_successfully": "¡Modelo cargado exitosamente!",
                "remove": "Eliminar",
                "test": "Prueba",
                "testing": "Probando...",
                "api_test_success": "¡La clave API funciona correctamente!",
                "api_test_error": "La clave API no funciona. Verifique la clave e intente nuevamente.",
                "select_api_for_test": "Seleccionar clave API para probar",
                "model_load_error": "Error al cargar el modelo",
                "search_error": "Error de búsqueda",
                "edit_message": "Editar mensaje",
                "delete_message": "Eliminar mensaje",
                "edit_dialog_title": "Editar mensaje",
                "message_label": "Mensaje:",
                "upload_file_tooltip": "Subir archivo",
                "attach_image_tooltip": "Adjuntar imagen"
            },
            "fr": {
                "app_title": "Maxport AIagent - Intelligence Artificielle",
                "thinking": "Réflexion...",
                "ready": "Prêt",
                "error": "Erreur",
                "success": "Succès",
                "loading": "Chargement...",
                "voice_enabled": "Voix activée",
                "voice_disabled": "Voix désactivée",
                "settings": "Paramètres",
                "language": "Langue",
                "theme": "Thème",
                "save": "Enregistrer",
                "cancel": "Annuler",
                "ok": "OK",
                "yes": "Oui",
                "no": "Non",
                "close": "Fermer",
                "minimize": "Réduire",
                "maximize": "Agrandir",
                "about": "À propos",
                "help": "Aide",
                "exit": "Quitter",
                "file": "Fichier",
                "edit": "Modifier",
                "view": "Affichage",
                "tools": "Outils",
                "plugins": "Plugins",
                "creative_studio": "Studio Créatif",
                "voice_control": "Contrôle Vocal",
                "web_search": "Recherche Web",
                "code_generation": "Génération de Code",
                "system_optimization": "Optimisation Système",
                "change_theme": "Changer le Thème",
                "enter_message_placeholder": "Entrez un message...",
                "send_button": "Envoyer",
                "ai_settings_tab": "Paramètres IA",
                "monitoring_tab": "Surveillance",
                "ai_model_settings": "Paramètres du Modèle IA",
                "hardware_specs": "Spécifications Matérielles",
                "ram": "RAM",
                "cpu_threads": "Threads CPU",
                "recommended_model_size": "Taille de Modèle Recommandée",
                "gpu_acceleration": "Accélération GPU",
                "gpu_offload_percent": "Pourcentage de Décharge GPU",
                "local_model": "Modèle Local",
                "apply": "Appliquer",
                "temperature": "Température",
                "context_length": "Longueur du Contexte",
                "available_models_for_download": "Modèles Disponibles au Téléchargement",
                "find_models": "Trouver des Modèles",
                "download_selected_model": "Télécharger le Modèle Sélectionné",
                "cloud_ai_models": "Modèles IA Cloud",
                "enter_api_key_placeholder": "Entrez la clé API...",
                "add": "Ajouter",
                "voice_settings": "Paramètres Vocaux",
                "speak_responses": "Lire les Réponses",
                "voice_selection": "Sélection de la Voix",
                "privacy_settings": "Paramètres de Confidentialité",
                "allow_data_transfer": "Autoriser le Transfert de Données",
                "cleanup_old_data": "Nettoyer les Anciennes Données",
                "cpu_usage": "Utilisation CPU",
                "ram_usage": "Utilisation RAM",
                "gpu_usage": "Utilisation GPU",
                "processes": "Processus",
                "name_header": "Nom",
                "cpu_header": "CPU %",
                "memory_header": "Mémoire",
                "select_model_to_load": "Sélectionner le modèle à charger",
                "loading_model": "Chargement du modèle: {model_name}",
                "process_info_question": "Expliquez en termes simples ce que fait le processus nommé '{process_name}'.\nIl est exécuté par l'utilisateur: {username}.\nChemin du fichier exécutable: {exe_path}.\nLigne de commande: {cmdline}\n\nEst-ce un processus système ou utilisateur? Est-ce un processus légitime ou pourrait-il être suspect?",
                "stop_process": "Arrêter le processus",
                "ask_about_process": "Demander sur le processus",
                "models_not_found": "Modèles non trouvés",
                "searching_models": "Recherche de modèles...",
                "search_error": "Erreur de recherche",
                "initial_greeting": "Bonjour! Je suis Maxport. Comment puis-je vous aider?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Renommer le chat",
                "new_chat_name_label": "Nouveau nom de chat:",
                "gpu_not_found": "GPU non trouvé",
                "no_model_selected": "Aucun modèle sélectionné",
                "analyze_screen_title": "Analyse d'Écran",
                "analyze_screen_prompt": "Que chercher dans la capture d'écran?",
                "model_loaded_successfully": "Modèle chargé avec succès!",
                "remove": "Supprimer",
                "test": "Test",
                "testing": "Test en cours...",
                "api_test_success": "La clé API fonctionne correctement!",
                "api_test_error": "La clé API ne fonctionne pas. Vérifiez la clé et réessayez.",
                "select_api_for_test": "Sélectionner la clé API pour le test",
                "model_load_error": "Erreur de chargement du modèle",
                "search_error": "Erreur de recherche",
                "edit_message": "Modifier le message",
                "delete_message": "Supprimer le message",
                "edit_dialog_title": "Modifier le message",
                "message_label": "Message:",
                "upload_file_tooltip": "Télécharger un fichier",
                "attach_image_tooltip": "Joindre une image"
            },
            "it": {
                "app_title": "Maxport AIagent - Intelligenza Artificiale",
                "thinking": "Pensando...",
                "ready": "Pronto",
                "error": "Errore",
                "success": "Successo",
                "loading": "Caricamento...",
                "voice_enabled": "Voce attivata",
                "voice_disabled": "Voce disattivata",
                "settings": "Impostazioni",
                "language": "Lingua",
                "theme": "Tema",
                "save": "Salva",
                "cancel": "Annulla",
                "ok": "OK",
                "yes": "Sì",
                "no": "No",
                "close": "Chiudi",
                "minimize": "Riduci",
                "maximize": "Ingrandisci",
                "about": "Informazioni",
                "help": "Aiuto",
                "exit": "Esci",
                "file": "File",
                "edit": "Modifica",
                "view": "Visualizza",
                "tools": "Strumenti",
                "plugins": "Plugin",
                "creative_studio": "Studio Creativo",
                "voice_control": "Controllo Vocale",
                "web_search": "Ricerca Web",
                "code_generation": "Generazione Codice",
                "system_optimization": "Ottimizzazione Sistema",
                "change_theme": "Cambia Tema",
                "enter_message_placeholder": "Inserisci messaggio...",
                "send_button": "Invia",
                "ai_settings_tab": "Impostazioni IA",
                "monitoring_tab": "Monitoraggio",
                "ai_model_settings": "Impostazioni Modello IA",
                "hardware_specs": "Specifiche Hardware",
                "ram": "RAM",
                "cpu_threads": "Thread CPU",
                "recommended_model_size": "Dimensione Modello Consigliata",
                "gpu_acceleration": "Accelerazione GPU",
                "gpu_offload_percent": "Percentuale Scarico GPU",
                "local_model": "Modello Locale",
                "apply": "Applica",
                "temperature": "Temperatura",
                "context_length": "Lunghezza Contesto",
                "available_models_for_download": "Modelli Disponibili per il Download",
                "find_models": "Trova Modelli",
                "download_selected_model": "Scarica Modello Selezionato",
                "cloud_ai_models": "Modelli IA Cloud",
                "enter_api_key_placeholder": "Inserisci chiave API...",
                "add": "Aggiungi",
                "voice_settings": "Impostazioni Voce",
                "speak_responses": "Pronuncia Risposte",
                "voice_selection": "Selezione Voce",
                "privacy_settings": "Impostazioni Privacy",
                "allow_data_transfer": "Consenti Trasferimento Dati",
                "cleanup_old_data": "Pulizia Dati Vecchi",
                "cpu_usage": "Utilizzo CPU",
                "ram_usage": "Utilizzo RAM",
                "gpu_usage": "Utilizzo GPU",
                "processes": "Processi",
                "name_header": "Nome",
                "cpu_header": "CPU %",
                "memory_header": "Memoria",
                "select_model_to_load": "Seleziona modello da caricare",
                "loading_model": "Caricamento modello: {model_name}",
                "process_info_question": "Spiega in termini semplici cosa fa il processo chiamato '{process_name}'.\nÈ eseguito dall'utente: {username}.\nPercorso del file eseguibile: {exe_path}.\nRiga di comando: {cmdline}\n\nÈ un processo di sistema o utente? È un processo legittimo o potrebbe essere sospetto?",
                "stop_process": "Ferma processo",
                "ask_about_process": "Chiedi sul processo",
                "models_not_found": "Modelli non trovati",
                "searching_models": "Ricerca modelli...",
                "search_error": "Errore di ricerca",
                "initial_greeting": "Ciao! Sono Maxport. Come posso aiutarti?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Rinomina chat",
                "new_chat_name_label": "Nuovo nome chat:",
                "gpu_not_found": "GPU non trovata",
                "no_model_selected": "Nessun modello selezionato",
                "analyze_screen_title": "Analisi Schermo",
                "analyze_screen_prompt": "Cosa cercare nello screenshot?",
                "model_loaded_successfully": "Modello caricato con successo!",
                "remove": "Rimuovi",
                "test": "Test",
                "testing": "Test in corso...",
                "api_test_success": "La chiave API funziona correttamente!",
                "api_test_error": "La chiave API non funziona. Controlla la chiave e riprova.",
                "select_api_for_test": "Seleziona chiave API per il test",
                "model_load_error": "Errore nel caricamento del modello",
                "search_error": "Errore di ricerca",
                "edit_message": "Modifica messaggio",
                "delete_message": "Elimina messaggio",
                "edit_dialog_title": "Modifica messaggio",
                "message_label": "Messaggio:",
                "upload_file_tooltip": "Carica file",
                "attach_image_tooltip": "Allega immagine"
            },
            "pl": {
                "app_title": "Maxport AIagent - Sztuczna Inteligencja",
                "thinking": "Myślę...",
                "ready": "Gotowy",
                "error": "Błąd",
                "success": "Sukces",
                "loading": "Ładowanie...",
                "voice_enabled": "Głos włączony",
                "voice_disabled": "Głos wyłączony",
                "settings": "Ustawienia",
                "language": "Język",
                "theme": "Motyw",
                "save": "Zapisz",
                "cancel": "Anuluj",
                "ok": "OK",
                "yes": "Tak",
                "no": "Nie",
                "close": "Zamknij",
                "minimize": "Minimalizuj",
                "maximize": "Maksymalizuj",
                "about": "O programie",
                "help": "Pomoc",
                "exit": "Wyjście",
                "file": "Plik",
                "edit": "Edytuj",
                "view": "Widok",
                "tools": "Narzędzia",
                "plugins": "Wtyczki",
                "creative_studio": "Studio Kreatywne",
                "voice_control": "Sterowanie Głosem",
                "web_search": "Wyszukiwanie w Sieci",
                "code_generation": "Generowanie Kodu",
                "system_optimization": "Optymalizacja Systemu",
                "change_theme": "Zmień Motyw",
                "enter_message_placeholder": "Wpisz wiadomość...",
                "send_button": "Wyślij",
                "ai_settings_tab": "Ustawienia SI",
                "monitoring_tab": "Monitorowanie",
                "ai_model_settings": "Ustawienia Modelu SI",
                "hardware_specs": "Specyfikacje Sprzętowe",
                "ram": "RAM",
                "cpu_threads": "Wątki CPU",
                "recommended_model_size": "Zalecany Rozmiar Modelu",
                "gpu_acceleration": "Przyspieszenie GPU",
                "gpu_offload_percent": "Procent Przeciążenia GPU",
                "local_model": "Model Lokalny",
                "apply": "Zastosuj",
                "temperature": "Temperatura",
                "context_length": "Długość Kontekstu",
                "available_models_for_download": "Dostępne Modele do Pobrania",
                "find_models": "Znajdź Modele",
                "download_selected_model": "Pobierz Wybrany Model",
                "cloud_ai_models": "Modele SI w Chmurze",
                "enter_api_key_placeholder": "Wpisz klucz API...",
                "add": "Dodaj",
                "voice_settings": "Ustawienia Głosu",
                "speak_responses": "Wymawiaj Odpowiedzi",
                "voice_selection": "Wybór Głosu",
                "privacy_settings": "Ustawienia Prywatności",
                "allow_data_transfer": "Zezwól na Transfer Danych",
                "cleanup_old_data": "Wyczyść Stare Dane",
                "cpu_usage": "Użycie CPU",
                "ram_usage": "Użycie RAM",
                "gpu_usage": "Użycie GPU",
                "processes": "Procesy",
                "name_header": "Nazwa",
                "cpu_header": "CPU %",
                "memory_header": "Pamięć",
                "select_model_to_load": "Wybierz model do załadowania",
                "loading_model": "Ładowanie modelu: {model_name}",
                "process_info_question": "Wyjaśnij prostymi słowami, co robi proces o nazwie '{process_name}'.\nJest uruchomiony przez użytkownika: {username}.\nŚcieżka do pliku wykonywalnego: {exe_path}.\nLinia poleceń: {cmdline}\n\nCzy to proces systemowy czy użytkownika? Czy to legalny proces czy może być podejrzany?",
                "stop_process": "Zatrzymaj proces",
                "ask_about_process": "Zapytaj o proces",
                "models_not_found": "Modele nie znalezione",
                "searching_models": "Wyszukiwanie modeli...",
                "search_error": "Błąd wyszukiwania",
                "initial_greeting": "Cześć! Jestem Maxport. Jak mogę pomóc?",
                "chat_tab_title": "Czat",
                "rename_chat_title": "Zmień nazwę czatu",
                "new_chat_name_label": "Nowa nazwa czatu:",
                "gpu_not_found": "GPU nie znaleziono",
                "no_model_selected": "Nie wybrano modelu",
                "analyze_screen_title": "Analiza Ekranu",
                "analyze_screen_prompt": "Czego szukać na zrzucie ekranu?",
                "model_loaded_successfully": "Model załadowany pomyślnie!",
                "remove": "Usuń",
                "test": "Test",
                "testing": "Testowanie...",
                "api_test_success": "Klucz API działa poprawnie!",
                "api_test_error": "Klucz API nie działa. Sprawdź klucz i spróbuj ponownie.",
                "select_api_for_test": "Wybierz klucz API do testu",
                "model_load_error": "Błąd ładowania modelu",
                "search_error": "Błąd wyszukiwania",
                "edit_message": "Edytuj wiadomość",
                "delete_message": "Usuń wiadomość",
                "edit_dialog_title": "Edytuj wiadomość",
                "message_label": "Wiadomość:",
                "upload_file_tooltip": "Prześlij plik",
                "attach_image_tooltip": "Dołącz obraz"
            },
            "uk": {
                "app_title": "Maxport AIagent - Штучний Інтелект",
                "thinking": "Думаю...",
                "ready": "Готово",
                "error": "Помилка",
                "success": "Успіх",
                "loading": "Завантаження...",
                "voice_enabled": "Голос увімкнено",
                "voice_disabled": "Голос вимкнено",
                "settings": "Налаштування",
                "language": "Мова",
                "theme": "Тема",
                "save": "Зберегти",
                "cancel": "Скасувати",
                "ok": "ОК",
                "yes": "Так",
                "no": "Ні",
                "close": "Закрити",
                "minimize": "Згорнути",
                "maximize": "Розгорнути",
                "about": "Про програму",
                "help": "Допомога",
                "exit": "Вихід",
                "file": "Файл",
                "edit": "Редагувати",
                "view": "Вигляд",
                "tools": "Інструменти",
                "plugins": "Плагіни",
                "creative_studio": "Творча Студія",
                "voice_control": "Голосове Керування",
                "web_search": "Веб-пошук",
                "code_generation": "Генерація Коду",
                "system_optimization": "Оптимізація Системи",
                "change_theme": "Змінити Тему",
                "enter_message_placeholder": "Введіть повідомлення...",
                "send_button": "Відправити",
                "ai_settings_tab": "Налаштування ШІ",
                "monitoring_tab": "Моніторинг",
                "ai_model_settings": "Налаштування Моделі ШІ",
                "hardware_specs": "Характеристики Обладнання",
                "ram": "ОЗП",
                "cpu_threads": "Потоки ЦП",
                "recommended_model_size": "Рекомендований Розмір Моделі",
                "gpu_acceleration": "Прискорення GPU",
                "gpu_offload_percent": "Відсоток Вивантаження на GPU",
                "local_model": "Локальна Модель",
                "apply": "Застосувати",
                "temperature": "Температура",
                "context_length": "Довжина Контексту",
                "available_models_for_download": "Доступні Моделі для Завантаження",
                "find_models": "Знайти Моделі",
                "download_selected_model": "Завантажити Вибрану Модель",
                "cloud_ai_models": "Хмарні Моделі ШІ",
                "enter_api_key_placeholder": "Введіть API ключ...",
                "add": "Додати",
                "voice_settings": "Налаштування Голосу",
                "speak_responses": "Озвучувати Відповіді",
                "voice_selection": "Вибір Голосу",
                "privacy_settings": "Налаштування Приватності",
                "allow_data_transfer": "Дозволити Передачу Даних",
                "cleanup_old_data": "Очистити Старі Дані",
                "cpu_usage": "Використання ЦП",
                "ram_usage": "Використання ОЗП",
                "gpu_usage": "Використання GPU",
                "processes": "Процеси",
                "name_header": "Назва",
                "cpu_header": "ЦП %",
                "memory_header": "Пам'ять",
                "select_model_to_load": "Виберіть модель для завантаження",
                "loading_model": "Завантаження моделі: {model_name}",
                "process_info_question": "Поясніть простими словами, що робить процес з назвою '{process_name}'.\nВін запущений користувачем: {username}.\nШлях до виконуваного файлу: {exe_path}.\nКомандний рядок: {cmdline}\n\nЦе системний чи користувацький процес? Це легітимний процес чи він може бути підозрілим?",
                "stop_process": "Зупинити процес",
                "ask_about_process": "Запитати про процес",
                "models_not_found": "Моделі не знайдено",
                "searching_models": "Пошук моделей...",
                "search_error": "Помилка пошуку",
                "initial_greeting": "Привіт! Я Maxport. Чим можу допомогти?",
                "chat_tab_title": "Чат",
                "rename_chat_title": "Перейменувати чат",
                "new_chat_name_label": "Нова назва чату:",
                "gpu_not_found": "GPU не знайдено",
                "no_model_selected": "Модель не вибрано",
                "analyze_screen_title": "Аналіз Екрану",
                "analyze_screen_prompt": "Що шукати на скріншоті?",
                "model_loaded_successfully": "Модель успішно завантажено!",
                "remove": "Видалити",
                "test": "Тест",
                "testing": "Тестування...",
                "api_test_success": "API ключ працює коректно!",
                "api_test_error": "API ключ не працює. Перевірте ключ і спробуйте знову.",
                "select_api_for_test": "Виберіть API ключ для тестування",
                "model_load_error": "Помилка завантаження моделі",
                "search_error": "Помилка пошуку",
                "edit_message": "Редагувати повідомлення",
                "delete_message": "Видалити повідомлення",
                "edit_dialog_title": "Редагувати повідомлення",
                "message_label": "Повідомлення:",
                "upload_file_tooltip": "Завантажити файл",
                "attach_image_tooltip": "Додати зображення"
            },
            "pt": {
                "app_title": "Maxport AIagent - Inteligência Artificial",
                "thinking": "Pensando...",
                "ready": "Pronto",
                "error": "Erro",
                "success": "Sucesso",
                "loading": "Carregando...",
                "voice_enabled": "Voz ativada",
                "voice_disabled": "Voz desativada",
                "settings": "Configurações",
                "language": "Idioma",
                "theme": "Tema",
                "save": "Salvar",
                "cancel": "Cancelar",
                "ok": "OK",
                "yes": "Sim",
                "no": "Não",
                "close": "Fechar",
                "minimize": "Minimizar",
                "maximize": "Maximizar",
                "about": "Sobre",
                "help": "Ajuda",
                "exit": "Sair",
                "file": "Arquivo",
                "edit": "Editar",
                "view": "Visualizar",
                "tools": "Ferramentas",
                "plugins": "Plugins",
                "creative_studio": "Estúdio Criativo",
                "voice_control": "Controle de Voz",
                "web_search": "Busca na Web",
                "code_generation": "Geração de Código",
                "system_optimization": "Otimização do Sistema",
                "change_theme": "Alterar Tema",
                "enter_message_placeholder": "Digite uma mensagem...",
                "send_button": "Enviar",
                "ai_settings_tab": "Configurações de IA",
                "monitoring_tab": "Monitoramento",
                "ai_model_settings": "Configurações do Modelo de IA",
                "hardware_specs": "Especificações de Hardware",
                "ram": "RAM",
                "cpu_threads": "Threads de CPU",
                "recommended_model_size": "Tamanho de Modelo Recomendado",
                "gpu_acceleration": "Aceleração GPU",
                "gpu_offload_percent": "Percentual de Descarga GPU",
                "local_model": "Modelo Local",
                "apply": "Aplicar",
                "temperature": "Temperatura",
                "context_length": "Comprimento do Contexto",
                "available_models_for_download": "Modelos Disponíveis para Download",
                "find_models": "Encontrar Modelos",
                "download_selected_model": "Baixar Modelo Selecionado",
                "cloud_ai_models": "Modelos de IA na Nuvem",
                "enter_api_key_placeholder": "Digite a chave API...",
                "add": "Adicionar",
                "voice_settings": "Configurações de Voz",
                "speak_responses": "Falar Respostas",
                "voice_selection": "Seleção de Voz",
                "privacy_settings": "Configurações de Privacidade",
                "allow_data_transfer": "Permitir Transferência de Dados",
                "cleanup_old_data": "Limpar Dados Antigos",
                "cpu_usage": "Uso de CPU",
                "ram_usage": "Uso de RAM",
                "gpu_usage": "Uso de GPU",
                "processes": "Processos",
                "name_header": "Nome",
                "cpu_header": "CPU %",
                "memory_header": "Memória",
                "select_model_to_load": "Selecionar modelo para carregar",
                "loading_model": "Carregando modelo: {model_name}",
                "process_info_question": "Explique em termos simples o que o processo chamado '{process_name}' faz.\nÉ executado pelo usuário: {username}.\nCaminho do arquivo executável: {exe_path}.\nLinha de comando: {cmdline}\n\nÉ um processo do sistema ou do usuário? É um processo legítimo ou pode ser suspeito?",
                "stop_process": "Parar processo",
                "ask_about_process": "Perguntar sobre processo",
                "models_not_found": "Modelos não encontrados",
                "searching_models": "Buscando modelos...",
                "search_error": "Erro de busca",
                "initial_greeting": "Olá! Eu sou Maxport. Como posso ajudar?",
                "chat_tab_title": "Chat",
                "rename_chat_title": "Renomear chat",
                "new_chat_name_label": "Novo nome do chat:",
                "gpu_not_found": "GPU não encontrada",
                "no_model_selected": "Nenhum modelo selecionado",
                "analyze_screen_title": "Análise de Tela",
                "analyze_screen_prompt": "O que procurar na captura de tela?",
                "model_loaded_successfully": "Modelo carregado com sucesso!",
                "remove": "Remover",
                "test": "Teste",
                "testing": "Testando...",
                "api_test_success": "A chave API funciona corretamente!",
                "api_test_error": "A chave API não funciona. Verifique a chave e tente novamente.",
                "select_api_for_test": "Selecionar chave API para teste",
                "model_load_error": "Erro ao carregar o modelo",
                "search_error": "Erro de busca",
                "edit_message": "Editar mensagem",
                "delete_message": "Excluir mensagem",
                "edit_dialog_title": "Editar mensagem",
                "message_label": "Mensagem:",
                "upload_file_tooltip": "Enviar arquivo",
                "attach_image_tooltip": "Anexar imagem"
            }
        }
    
    def set_language(self, language: str):
        """Устанавливает текущий язык"""
        if language in self.translations:
            self.current_language = language
    
    def get(self, key: str, default: str = None) -> str:
        """Получает перевод по ключу"""
        if self.current_language in self.translations:
            return self.translations[self.current_language].get(key, default or key)
        return default or key
    
    def get_all(self) -> Dict[str, str]:
        """Получает все переводы для текущего языка"""
        return self.translations.get(self.current_language, {})
    
    def add_translation(self, language: str, key: str, value: str):
        """Добавляет новый перевод"""
        if language not in self.translations:
            self.translations[language] = {}
        self.translations[language][key] = value
    
    def tr(self, key: str) -> str:
        """Алиас для метода get() для совместимости"""
        return self.get(key)
    
    def get_available_languages(self) -> dict:
        """Возвращает словарь доступных языков с их названиями"""
        return {
            "ru": "Русский",
            "en": "English",
            "de": "Deutsch",
            "es": "Español",
            "fr": "Français",
            "it": "Italiano",
            "pl": "Polski",
            "uk": "Українська",
            "pt": "Português"
        }

# Глобальный экземпляр переводчика
translator = Translator()
